/*==========================================================================

				m k s y m
				=========

	Reads a symbol file generated by the Hi-Tech C linker and
	generates a symbol file compatible with the Z8E debugger.

	Default title for input file is L.SYM.  Output file has the
	same name as the input file.  A different input (and output)
	file name may be specified on the command line.

	mksym			reformats L.SYM
	mksym abc.sym		reformats ABC.SYM

==========================================================================*/

#include <stdio.h>

unsigned char sym[81];
unsigned short int addr;
unsigned char fName[20] = {"L.SYM"};
unsigned char *fnp = fName;

FILE *fin, *fout;

main(argc,argv)
short int argc;
unsigned char *argv[];
{
   unsigned short int symbols = 0;
   fprintf(stderr,"Convert Hi-Tech C symbol file for use with Z8E\n");
   fprintf(stderr,"A public domain program by Jonathan Saxton\n\n");
   if (argc > 1)
      fnp = argv[1];
   if (((fin=fopen(fnp,"r")) == NULL) ||
       ((fout=fopen("L.$$$","w")) == NULL))
      {
	 printf("Either could not find input file %s or\ncould not create temporary output file L.$$$.", fnp);
	 exit(1);
      }
   while(fscanf(fin,"%x %s",&addr,&sym[0]) == 2)
      {
         fprintf(fout,"%04x %s\n",addr,&sym[0]);
	 fprintf(stderr,"%04x %s\n",addr,&sym[0]);
	 ++symbols;
      }
   fclose(fin);
   fclose(fout);
   unlink(fnp);
   rename("L.$$$",fnp);
   fprintf(stderr,"\n%u symbols",symbols);
}

