type  TextListe            = ^TextEintrag;
      TextEintrag          = record
                               M_Zeile : string[60];
                               naechst : TextListe;
                             end;
      MacroListe           = record
                               ParamListe : Zeile;
                               local      : char;
                               M_Liste    : TextListe
                             end;
      tEintrag             = record
                               VarName    : LabelString;
                               case Art:(extern,relativ,absolut,macro) of
                                 absolut,
                                 relativ  : (VarRef : integer);
                                 macro    : (MPtr : ^MacroListe)
                             end;
      SuchBaum             = ^SuchBaumEintrag;
      SuchBaumEintrag      = record
                               Eintrag    : tEintrag;
                               links,
                               rechts     : SuchBaum
                             end;

var   VarListe,
      SuchListe            : SuchBaum;
      VarEintrag           : tEintrag;
      TextStack            : TextListe;

function LinksVon(tE1,tE2:tEintrag):boolean;
begin
  LinksVon := tE1.VarName < tE2.VarName
end;

(*$A-*)
procedure Suche(SB:SuchBaum; Ref:tEintrag; var Gef:SuchBaum);
begin
  Gef := SB;
  if SB <> nil then
    if LinksVon(Ref,SB^.Eintrag) then
      Suche(SB^.links,Ref,Gef)
    else if LinksVon(SB^.Eintrag,Ref) then
      Suche(SB^.rechts,Ref,Gef)
end;

procedure FuegeEin(var SB:SuchBaum; Ref:tEintrag);
begin
  if SB=nil then begin
    new(SB);
    with SB^ do begin
      Eintrag := Ref;
      links := nil;  rechts := nil
    end
  end else
    if LinksVon(Ref,SB^.Eintrag) then
      FuegeEin(SB^.links,Ref)
    else if LinksVon(SB^.Eintrag,Ref) then
      FuegeEin(SB^.rechts,Ref)
    else
      SB^.Eintrag := Ref
end;
(*$A+*)

procedure SkipMacro(name:LabelString);
var  z, k, a1, a2 : Zeile;
     L, o         : LabelString;
     b            : byte;
     s            : SuchBaum;
     e            : tEintrag;
begin
  b := 1;
  e.VarName := name;
  Suche(VarListe,e,s);
  with s^,Eintrag do
    MPtr^.local := 'A';
  while (not EOF(source)) and (b>0) do begin
    readln(Source,z);
    ScanLine(z,L,o,a1,a2,k,'&');
    if o='MACRO' then b := succ(b);
    if o='ENDM' then b := pred(b)
  end
end;

procedure MachMacro(L:LabelString; p:Zeile);
label EXIT;
var  T            : tEintrag;
     count        : byte;
     q, r         : TextListe;
     h            : boolean;
     o            : LabelString;
     a1, a2, c    : Zeile;
begin
  count := 1;
  if L = '' then begin
    h := Error(12,L);
    goto exit
  end;
  with T do begin
    VarName := L;
    Art     := macro;
    new(MPtr);
    with MPtr^ do begin
      ParamListe := p;
      M_Liste    := nil;
      local      := 'A';
      if not EOF(source) then
        repeat
          readln(Source,p); ScanLine(p,L,o,a1,a2,c,'&');
          if a2 <> '' then a1 := a1+','+a2;
          if o='MACRO' then begin
            count := succ(count);
            h := Error(15,L)
          end;
          if o='ENDM' then count := pred(Count);
          if count=1 then begin
            new(r);
            r^.M_Zeile := L+' '+o+' '+a1;
            r^.naechst := nil;
            q := M_Liste;
            if q = nil then
              M_Liste := r
            else begin
              while q^.naechst <> nil do
                q := q^.naechst;
              q^.naechst := r
            end
          end
        until (count=0) or (EOF(source));
      if count>0 then h:= Error(19,'')
    end
  end;
  FuegeEin(VarListe,T);
EXIT:
end;

procedure PushMacro(M:MacroListe; Pr:Zeile);
var  t, p, q, a    : TextListe;
     Alt, Neu      : string[80];
     Pt            : Zeile;

  procedure Ersetze(var z,alt,neu:Zeile);
  begin
    while pos(alt,Z)>0 do begin
      insert(#1,Z,pos(alt,Z));
      delete(Z,pos(alt,Z),length(alt))
    end;
    while pos(#1,Z)>0 do begin
      insert(neu,Z,pos(#1,Z));
      delete(Z,pos(#1,Z),1)
    end
  end;

  procedure HolParameter(var von,par : Zeile);
  var i : byte;
  begin
    if von<>'' then begin
      von := von+',';
      i := pos(',',von);
      par := copy(von,1,i-1);
      delete(von,1,i);
      SkipLeftBlanks(par);
      SkipRightBlanks(par)
    end else
      par := ''
  end;

begin  (* PushMacro *)
  t := nil;  a := nil;
  with M do begin
    p := M_Liste;  Pt := ParamListe;
    while p <> nil do begin
      new(q);
      q^.naechst := nil;
      q^.M_Zeile := p^.M_Zeile;
      if t = nil then
        t := q
      else
        a^.naechst := q;
      a := q;  p := p^.naechst
    end;
    HolParameter(Pt,Alt);
    HolParameter(Pr,Neu);
    while Neu <> '' do begin
      a := t;
      while a <> nil do begin
        Ersetze(a^.M_Zeile,Alt,Neu);
        a := a^.naechst
      end;
      HolParameter(Pt,Alt);
      HolParameter(Pr,Neu)
    end;
    a := t;
    if t <> nil then
      while a^.naechst <> nil do
        a := a^.naechst;
    a^.naechst := TextStack;
    TextStack := t
  end
end;

procedure PopZeile(var z:Zeile);
var p : TextListe;
begin
  z := TextStack^.M_Zeile;
  p := TextStack;
  TextStack := TextStack^.naechst;
  dispose(p)
end;

