const  HexZiffer : array[0..15] of char = '0123456789ABCDEF';
       MaxLabel  = 8;

type   HexZahl   = string[4];

function HexByte(x:integer):HexZahl;
begin
  HexByte := HexZiffer[lo(x) shr 4]+HexZiffer[lo(x) and 15]
end;

function HexWord(x:integer):HexZahl;
begin
  HexWord := HexByte(hi(x)) + HexByte(lo(x))
end;

procedure SkipLeftBlanks(var z:Zeile);
begin
  while pos(' ',z)=1 do delete(z,1,1)
end;

procedure SkipRightBlanks(var z:Zeile);
begin
  while (length(z)>1) and (z[length(z)]=' ') do delete(z,length(z),1);
  if z=' ' then z:=''
end;

procedure SkipPar(var z:Zeile);
begin
  if pos('(',z)=1 then delete(z,1,1);
  if z<>'' then
    if z[length(z)]=')' then delete(z,length(z),1)
end;

function geklammert(var z:Zeile):boolean;
begin
  if z<>'' then
    geklammert := (z[1]='(') and (z[length(z)]=')')
  else
    geklammert := false
end;

procedure ScanLine( var sz:Zeile; var Lab,OpCode:LabelString;
                    var Arg1,Arg2,Kommentar:Zeile; Local:char);
var i, ka, le, oe, ae : byte;
    PFlag, KFlag      : boolean;

begin
  (* Tabs in Spaces umwandeln *)
  while pos(^i,sz)>0 do begin
    insert(' ',sz,pos(^i,sz));
    delete(sz,pos(^i,sz),1)
  end;

  PFlag := false; KFlag := false;
  ka := 0; le := 0;
  for i := 1 to length(sz) do begin
    if not (PFlag or KFlag) then begin
      sz[i] := upcase(sz[i]);
      if sz[i] = '&' then sz[i] := local;
      if (sz[i]=LabelEnde) and (le=0) then le := i;
      if (sz[i]=KommentarAnfang) and (ka=0) then begin
        ka := i; KFlag := true
      end
    end;
    if sz[i]='''' then
      if PFlag or (pos('AF''',sz)<>i-2) then PFlag := not PFlag
  end;
  if PFlag then sz := sz+'''';

  (* Kommentar entfernen *)
  Kommentar := '';
  if ka>0 then begin
    Kommentar := copy(sz,ka+1,length(sz)-ka);
    delete(sz,ka,length(sz)-ka+1)
  end;

  (* Label entfernen *)
  Lab := '';
  if le>0 then begin
    SkipLeftBlanks(sz);
    le := pos(LabelEnde,sz)
  end else
    if sz<>'' then
      if sz[1] in ['A'..'Z'] then
        le := pos(' ',sz+' ');
  if le>0 then begin
    Lab := copy(sz,1,le-1);
    delete(sz,1,le)
  end;

  (* Opcode und Argumente entfernen *)
  SkipLeftBlanks(sz);
  Arg1 := ''; Arg2 := ''; oe := pos(' ',sz);
  if oe=0 then
    opcode := sz
  else begin
    opcode := copy(sz,1,oe);
    delete(sz,1,oe);
    SkipLeftBlanks(sz);
    ae := pos(ArgumentTrennung,sz);
    if ae=0 then
      Arg1 := sz
    else begin
      Arg1 := copy(sz,1,ae-1);
      delete(sz,1,ae);
      SkipLeftBlanks(sz);
      Arg2 := sz
    end
  end;
  SkipRightBlanks(opcode);
  SkipRightBlanks(Arg1);
  SkipRightBlanks(Arg2)
end;


