Program InlAss_80;

(* Inlineassembler fuer TURBO-Pascal *)
(* aus CHIP-Sonderheft PASCAL 2      *)

(*$V-*)

const   KommentarAnfang      = ';';
        ArgumentTrennung     = ',';
        LabelEnde            = ':';

type    Zeile                = string[80];
        string14             = string[14];
        LabelString          = string[16];
        AnyStr               = string[255];

var     FileName             : string14;
        Source,
        Objekt,
        PRNfile              : text;
        Loader               : file;
        PC                   : integer;
        FehlerZahl           : integer;
        MakeINL,
        MakePRN,
        First,
        AutoLoad,
        SourceDa,
        KommentarFlag        : boolean;
        SOU_Device,
        PRN_Device,
        OBJ_Device           : string[2];
        Ext                  : string[3];
        PunktPos             : byte;
        Antwort              : char;
        KommStr              : string[2];

procedure Wait;
begin repeat until keypressed end;

(*$I CONSTSTR.FCT *)
(*$I SCANLINE.INC *)
(*$I ERROR.INC    *)
(*$I SUCHBAUM.INC *)
(*$I BERECHNE.INC *)
(*$I HL1-Z80.INC  *)
(* $I C:HL2-6502.INC *)
(* $I C:HL3-8080.INC *)
(* $I C:HL4-8086.INC *)
(*$I INL.INC      *)
(*$I DOPASS.INC   *)

begin    (* MAIN *)

  ClrScr; writeln(^[,'S');
          writeln('INLINE-Assembler f}r TURBO-Pascal');
          writeln('--------------------------------');
          writeln;
          writeln('   Version vom 19. M{rz 1988');
          writeln;

  FehlerZahl := 0;
  KommentarFlag := true;
  SOU_Device := '';
  OBJ_Device := '';
  PRN_Device := '';

  AutoLoad := false;
  if ParamCount = 0 then begin
    write('*'); BufLen := 14; readln(FileName);
    write('Source als Kommentar (J/N) ? ');
    repeat
      read(kbd,Antwort); Antwort := Upcase(Antwort)
    until Antwort in ['J','N'];
    writeln(Antwort);
    KommentarFlag := Antwort = 'J';
  end else begin
    FileName := ParamStr(1);
    if ParamCount > 1 then begin
      KommStr := ParamStr(2);
      KommentarFlag := not(KommStr[1] in ['L','l','N','n']);
      AutoLoad      := KommStr[1] in ['L','l']
    end
  end;

  PunktPos := pos('.',FileName);
  if PunktPos > 0 then begin
    Ext := copy(FileName,PunktPos+1,length(FileName)-PunktPos);
    if Ext <> '' then
      while length(Ext)<3 do
        Ext := Ext+Ext[1];
    delete(FileName,PunktPos,length(FileName)-PunktPos+1)
  end else
    Ext := '';

  if Ext<>'' then begin
    SOU_Device := Ext[1]+':';
    OBJ_Device := Ext[2]+':';
    PRN_Device := Ext[3]+':'
  end;

  MakeINL := OBJ_Device <> 'X:';
  MakePRN := PRN_Device <> 'X:';

  assign(Source,SOU_Device+FileName+'.SOU');
  {$I-}
  reset(Source);
  SourceDa := IOResult = 0;
  close(Source);
  {$I+}
  If not SourceDa then 
     begin
     writeln; writeln('Source-Datei ',SOU_Device+FileName+'.SOU fehlt');
     writeln; writeln('Programmabbruch...');
     halt;
     end;
  
  if MakeINL then begin
    assign(Objekt,OBJ_Device+FileName+'.INL'); rewrite(Objekt);
  end;
  if MakePRN then begin
    assign(PRNFile,PRN_Device+FileName+'.PRN'); rewrite(PRNFile);
  end;

  VarListe := nil;

  writeln(SOU_Device+FileName+'.SOU');
  writeln('--> ',OBJ_Device+FileName+'.INL');
  writeln('--> ',PRN_Device+FileName+'.PRN');

  if MakePRN then
    writeln(PRNFile,'PASS 1:');
  DoPass(1);
  if MakePRN then begin
    writeln(PRNFile);
    writeln(PRNFile,'PASS 2:');
    end;
  DoPass(2);
  if MakePRN then
    writeln(PRNFile);

  VariablenListe(VarListe);
  if MakePRN then
    close(PRNFile);
  if MakeINL then
    close(Objekt);

  writeln(FehlerZahl,' Fehler.');

  if (FehlerZahl=0) and AutoLoad then begin
    assign(Loader,'INLOAD.CHN');
    chain(Loader)
  end

end.

