(* overlay *) procedure HexLine1(var o:LabelString; a1, a2:Zeile;
                                 var H:Zeile);
type  string3   = string[4];
      string30  = string[30];

const ib        : array[1..2] of integer
                = ($DD,$FD);

var   d         : string30;
      fc, b     : integer;
      on        : byte;
      DR,I,R1,
      R2,C      : integer;
      D1,D2     : byte;

  function NI(x:byte):string3;
  begin
    ni := '$'+HexByte(IB[x])+'/'
  end;

  function DD(var a:string3):byte;
  var   i,t : byte;
  const drn : array[1..6] of string[2]
            = ('BC','DE','HL','IX','IY','SP');
  begin
    t := 0;
    for i := 1 to 6 do
      if drn[i]=a then
        t := i;
    dd := t
  end;

const HH : array[0..68] of integer =
      (-1,-1,-1,-1,-1,-1,$3f,-1,$eda9,$edb9,$eda1,$edb1,$2f,$27,
       -1,$f3,-1,$fb,-1,$d9,$76,-1,-1,-1,$edaa,$edba,$eda2,$edb2,
       -1,-1,-1,$eda8,$edb8,$eda0,$edb0,$ed44,$00,-1,$edbb,$edb3,
       -1,$edab,$eda3,-1,-1,-1,-1,$ed4d,$ed45,-1,$17,-1,$07,$ed6f,
       -1,$1f,-1,$0f,$ed67,-1,-1,$37,-1,-1,-1,-1,-1,-1,-1);

  function OpCodeNummer(var z:LabelString):integer;
  const OpCodeName : array[1..68] of string[4] =
        ('ADC','ADD','AND','BIT','CALL','CCF','CP','CPD','CPDR','CPI',
         'CPIR','CPL','DAA','DEC','DI','DJNZ','EI','EX','EXX','HALT',
         'IM','IN','INC','IND','INDR','INI','INIR','JP','JR','LD',
         'LDD','LDDR','LDI','LDIR','NEG','NOP','OR','OTDR','OTIR','OUT',
         'OUTD','OUTI','POP','PUSH','RES','RET','RETI','RETN','RL','RLA',
         'RLC','RLCA','RLD','RR','RRA','RRC','RRCA','RRD','RST','SBC',
         'SCF','SET','SLA','SLIA','SRA','SRL','SUB','XOR');
  var   i,j,m : integer;
  begin
    i := 1; j := 68;
    repeat
      m := (i+j) div 2;
      if z<=OpCodeName[m] then j := m
                            else i := m+1
    until i=j;
    if OpCodeName[i]=z then
      OpCodeNummer:=i
    else
      OpCodeNummer := 0
  end;

  procedure HNorm(x:integer; var HN:Zeile);
  begin
    HN := '';
    if x<>-1 then begin
      if hi(x)>0 then HN := '$'+HexByte(hi(x))+'/';
      HN := HN+'$'+HexByte(lo(x))
    end
  end;

  function Regs(var a:Zeile):integer;
  const Regname:array[0..6] of char = 'BCDEHLA';
        Reg2Name:array[0..3] of string[2] = ('HX','HY','LX','LY');
  var   i : 0..6;
  begin
    Regs := -1;
    for i := 0 to 3 do
      if a=Reg2Name[i] then
        Regs := i+8;
    for i:= 0 to 6 do
      if a=RegName[i] then
        if i=6 then Regs:=7
               else Regs:=i
  end;

  function DubRegs(var a:Zeile; rr:string3):integer;
  const RegName : array[0..3] of string[2] = ('BC','DE','HL','SP');
  var   i : 0..3;
  begin
    if rr='AF' then begin
      RegName[2] := 'HL'; RegName[3] := rr
    end else begin
      RegName[2] := rr; RegName[3] := 'SP'
    end;
    DubRegs := -1;
    for i:=0 to 3 do
      if a=Regname[i] then
        DubRegs := i
  end;

  function Cond(var a:Zeile):integer;
  const CondName : array[0..7] of string[2] =
        ('NZ','Z','NC','C','PO','PE','P','M');
  var   i : 0..7;
  begin
    Cond := -1;
    for i := 0 to 7 do
      if a=CondName[i] then
        Cond := i
  end;

  function Indexed(a:string30; var d:Zeile):integer;
  begin
    while pos(' ',a)>0 do delete(a,pos(' ',a),1);
    if length(a)>4 then begin
      d:= '<'+copy(a,4,length(a)-4);
      if pos('_',d)>0 then
        if on in [45,49,51,54,56,62..66] then begin
          d := copy(d,1,pos('_',d)-2);
          if d='<' then
            d := '<0'
          else
        end else
          a := ''
      else
    end else
      if (a='(IX)') or (a='(IY)') then
        d := '<0'
      else begin
        d := '';
        a := ''
      end;
    if copy(a,1,3)='(IX' then
      Indexed := 1
    else if copy(a,1,3)='(IY' then
      Indexed := 2
    else
      Indexed := -1;
  end;

  procedure HStandard(var a2:Zeile; rg, sh, n, hl:byte; var HS:string30);
  var r,i : integer;
  begin
    R := Regs(a2);  I := Indexed(a2,d);
    if r>=0 then
      if r>=8 then begin
        HNorm(rg or (((r and $a) div 2) shl sh),hs);
        HS := NI((r and 1)+1)+hs
      end else
        HNorm(rg or (r shl sh),hs)
    else if i>0 then begin
      HNorm((IB[i] shl 8) or hl,HS);
      HS := HS+'/'+d
    end else if a2='(HL)' then
      HNorm(hl,HS)
    else if n<>0 then begin
      HNorm(n,HS);
      HS := HS+'/<'+a2
    end else
      HS := ''
  end;

  procedure HBit(var a2:Zeile; b2,b:byte; var HB:string30);
  var i,r,rx:integer;
  begin
    i := Indexed(a2,d);  r := Regs(a2);
    if (r>=0) and (r<8) then
      HNorm($cb00 or (b2 or r or (b shl 3)),HB)
    else if i>0 then begin
      if pos('_',a2)=0 then
        rx := 6
      else begin
        a2 := copy(a2,pos('_',a2)+1,length(a2)-pos('_',a2));
        rx := Regs(a2)
      end;
      if (rx>=0) and (rx<8) then begin
        HNorm(b2 or rx or (b shl 3),HB);
        HB := NI(i)+'$CB/'+d+'/'+HB
      end else
        HB := ''
    end else if a2='(HL)' then
      HNorm($cb00 or (b2 or 6 or (b shl 3)),HB)
    else HB := '';
  end;

  procedure HRot(var a:Zeile; b1,rc:byte; var HR:string30);
  var r,i,rx:integer;
  begin
    r := Regs(a);  i := Indexed(a,d);
    if (r>=0) and (r<8) then
      HNorm($cb00 or (rc or r),HR)
    else if a='(HL)' then
      HNorm($cb00 or b1,HR)
    else if i>0 then begin
      if pos('_',a)=0 then
        rx := b1 xor rc
      else begin
        a := copy(a,pos('_',a)+1,length(a)-pos('_',a));
        rx := Regs(a)
      end;
      if (rx>=0) and (rx<8) then begin
        HNorm(rc or rx,HR);
        HR := NI(i)+'$CB/'+d+'/'+HR
      end else
        HR := ''
    end else
      HR := '';
  end;

begin  (* HexLine1 *)
  R1 := Regs(a1);  R2 := Regs(a2);
  D1 := DD(a1);    D2 := DD(a2);
  C  := Cond(a1);  on := OpCodeNummer(o);
  HNorm(HH[on],H);
  if H='' then
    case on of
       1 : if a1='A' then
             HStandard(a2,$88,0,$ce,$8e,H)
           else if D1=3 then begin
             DR := DubRegs(a2,a1);
             if DR>=0 then
               HNorm($ed00 or ($4a or (DR shl 4)),H)
           end;
       2 : if a1='A' then
             HStandard(a2,$80,0,$c6,$86,H)
           else begin
             DR := DubRegs(a2,a1);
             if DR>=0 then
               case D1 of
                 3 : HNorm($09 or (DR shl 4),H);
                 4 : HNorm($dd00 or ($09 or (DR shl 4)),H);
                 5 : HNorm($fd00 or ($09 or (DR shl 4)),H)
               end
           end;
       3 : HStandard(a1,$a0,0,$e6,$a6,H);
       4 : begin
             Berechne(a1,b,fc);
             HBit(a2,$40,lo(b),H)
           end;
       5 : if C>=0 then begin
             HNorm($c4 or (C shl 3),H);
             H := H+'/'+a2
           end else
             H := '$CD/'+a1;
       7 : HStandard(a1,$b8,0,$fe,$be,H);
      14 : begin
             DR := DubRegs(a1,'HL');
             if DR >= 0 then
               HNorm($0b or (DR shl 4),H)
             else if D1=4 then
               HNorm($dd2b,H)
             else if D1=5 then
               HNorm($fd2b,H)
             else
               HStandard(a1,$05,3,0,$35,H)
           end;
      16 : H := '$10/~'+a1;
      18 : if a1='(SP)' then
             case D2 of
               3 : HNorm($e3,H);
               4 : HNorm($dde3,H);
               5 : HNorm($fde3,H)
             end
           else if (a1='AF') and (a2='AF''') then
             HNorm($08,H)
           else if (D1=2) and (D2=3) then
             HNorm($eb,H);
      21 : case a1[1] of
             '0' : HNorm($ed46,H);
             '1' : HNorm($ed56,H);
             '2' : HNorm($ed5e,H)
           end;
      22 : if a2='(C)' then begin
             if Regs(a1)>=0 then
               HNorm($ed00 or ($40 or (Regs(a1) shl 3)),H)
           end else if a1='A' then begin
             SkipPar(a2);
             H := '$DB/<'+a2
           end;
      23 : begin
             DR := DubRegs(a1,'HL');
             if DR>=0 then
               HNorm($03 or (DR shl 4),H)
             else if D1=4 then
               HNorm($dd23,H)
             else if D1=5 then
               HNorm($fd23,H)
             else
               HStandard(a1,$04,3,0,$34,H)
           end;
      28 : if c>=0 then
             H := '$'+HexByte($c2 or (c shl 3))+'/'+a2
           else if a1='(HL)' then
             HNorm($e9,H)
           else if a1='(IX)' then
             HNorm($dde9,H)
           else if a1='(IY)' then
             HNorm($fde9,H)
           else
             H := '$C3/'+a1;
      29 : if c>=0 then
             H := '$'+HexByte($20 or (c shl 3))+'/~'+a2
           else
             H := '$18/~'+a1;
      30 : if geklammert(a1) then begin
             I := Indexed(a1,d); SkipPar(a1);
             if a1='HL' then
               if R2>=0 then
                 H := '$'+HexByte($70 or R2)
               else
                 H := '$36/<'+a2
             else if (a1='BC') and (R2=7) then
               H := '$02'
             else if (a1='DE') and (R2=7) then
               H := '$12'
             else if i>0 then
               if r2>=0 then
                 H := NI(i)+'$'+HexByte($70 or R2)+'/'+d
               else
                 H := NI(i)+'$36/'+d+'/<'+a2
             else if r2=7 then
               H := '$32/'+a1
             else
               case D2 of
                 1 : H := '$ED/$43/'+a1;
                 2 : H := '$ED/$53/'+a1;
                 3 : H := '$22/'+a1;
                 4 : H := '$DD/$22/'+a1;
                 5 : H := '$FD/$22/'+a1;
                 6 : H := '$ED/$73/'+a1
               end
           end else if geklammert(a2) then begin
             I := Indexed(a2,d);  SkipPar(a2);
             if a2='HL' then
               if R1>=0 then
                 H := '$'+HexByte($46 or (R1 shl 3))
               else
             else if (a2='BC') and (R1=7) then
               H := '$0A'
             else if (a2='DE') and (R1=7) then
               H := '$1A'
             else if i>0 then
               if R1>=0 then
                 H := NI(i)+'$'+HexByte($46 or (R1 shl 3))+'/'+d
               else
             else if R1=7 then
               H := '$3A/'+a2
             else
               case D1 of
                 1 : H := '$ED/$4B/'+a2;
                 2 : H := '$ED/$5B/'+a2;
                 3 : H := '$2A/'+a2;
                 4 : H := '$DD/$2A/'+a2;
                 5 : H := '$FD/$2A/'+a2;
                 6 : H := '$ED/$7B/'+a2
               end
           end else
             if a1='SP' then
               if D2=3 then
                 H := '$F9'
               else if D2=4 then
                 H := '$DD/$F9'
               else if D2=5 then
                 H := '$FD/$F9'
               else
                 H := '$31/'+a2
             else if (R1>=0) and (R2>=0) then
               if (R1>=8) or (R2>=8) then
                 if (R1<>4) and (R1<>5) and (R2<>4) and (R2<>5) then begin
                   d := '';
                   if (((R1=8) or (R1=10)) and ((R2<>9) and (R2<>11))) or
                      (((R2=8) or (R2=10)) and ((R1<>9) and (R1<>11))) then
                        d := '$DD'
                   else if (((R1=9) or (R1=11)) and ((R2<>8) and (R2<>10))) or
                           (((R2=9) or (R2=11)) and ((R1<>8) and (R1<>10))) then
                        d := '$FD';
                   if R1>=8 then
                     R1 := ((R1 and $a) div 2);
                   if R2>=8 then
                     R2 := ((R2 and $a) div 2);
                   if d<>'' then
                     H := d+'/$'+HexByte($40 or (R1 shl 3) or R2)
                   else
                 end else
               else
                 H := '$'+HexByte($40 or (R1 shl 3) or R2)
             else if (R1=7) and (a2='I') then
               H := '$ED/$57'
             else if (R1=7) and (a2='R') then
               H := '$ED/$5F'
             else if (R1>=0) then
               if R1>=8 then begin
                 H := NI((r1 and 1)+1)+'$'+
                      HexByte($06 or (((R1 and $a) div 2) shl 3))+'/<'+a2
               end else
                 H := '$'+HexByte($06 or (R1 shl 3))+'/<'+a2
             else if DubRegs(a1,'HL')>=0 then
               H := '$'+HexByte($01 or (DubRegs(a1,'HL') shl 4))+'/'+a2
             else if D1=4 then
               H := '$DD/$21/'+a2
             else if D1=5 then
               H := '$DD/$21/'+a2
             else if (R2=7) and (a1='I') then
               H := '$ED/$47'
             else if (R2=7) and (a1='R') then
               H := '$ED/$4F';
      37 : HStandard(a1,$b0,0,$f6,$b6,H);
      40 : if a1='(C)' then begin
             if R2>=0 then
               HNorm($ed00 or ($41 or (r2 shl 3)),H)
           end else if a2='A' then begin
             SkipPar(a1);
             H := '$D3/<'+a1
           end;
      43 : if D1=4 then
             HNorm($DDE1,H)
           else if D1=5 then
             HNorm($FDE1,H)
           else if DubRegs(a1,'AF')>=0 then
             HNorm($c1 or (DubRegs(a1,'AF') shl 4),H);
      44 : if D1=4 then
             HNorm($DDE5,H)
           else if D1=5 then
             HNorm($FDE5,H)
           else if DubRegs(a1,'AF')>=0 then
             HNorm($c5 or (DubRegs(a1,'AF') shl 4),H);
      45 : begin
             Berechne(a1,b,fc);
             HBit(a2,$80,lo(b),H)
           end;
      46 : if C>=0 then
             HNorm($c0 or (C shl 3),H)
           else
             H := '$C9';
      49 : HRot(a1,$16,$10,H);
      51 : HRot(a1,$06,$00,H);
      54 : HRot(a1,$1e,$18,H);
      56 : HRot(a1,$0e,$08,H);
      59 : begin
             Berechne(a1,b,fc);
             if fc=0 then
               if (b mod 8)=0 then
                 HNorm($c7 or lo(b),H)
           end;
      60 : if a1='A' then
             HStandard(a2,$98,0,$de,$9e,H)
           else if D1=3 then
             if DubRegs(a2,'HL')>=0 then
               HNorm($ed00 or ($42 or (DubRegs(a2,'HL') shl 4)),H);
      62 : begin
             Berechne(a1,b,fc);
             HBit(a2,$c0,lo(b),H)
           end;
      63 : HRot(a1,$26,$20,H);
      64 : HRot(a1,$36,$30,H);
      65 : HRot(a1,$2e,$28,H);
      66 : HRot(a1,$3e,$38,H);
      67 : HStandard(a1,$90,0,$d6,$96,H);
      68 : HStandard(a1,$a8,0,$ee,$ae,H)
    end;
end;

