procedure DoPass(PASS:byte);

type PseudoOpcode = (pNO,pORG,pDS,pDB,pDL,pDW,pEXT,pEQU,pSET,pIF,pELSE,
                     pENDIF,pEND,pMACRO,pZ80,p6502,p8080,p8086,pABS);
const NoLabelOp : set of PseudoOpcode = [pEQU,pSET,pDL,pEXT,pMACRO];
var   DoFlag                          : array[byte] of boolean;
      IfCount1, IfCount2, BZ          : byte;
      OPCODE, Lab                     : LabelString;
      POp                             : PseudoOpcode;
      SourceZeile,Com,L,Arg1,Arg2,h1  : Zeile;
      te                              : tEintrag;
      Fehler,i,er,pc1,Anzahl          : integer;
      EndOfSource,Do1,h,PrintFlag,Aseg: boolean;
      L1                              : Zeile;
      Prozessor                       : (MPC_Z80,MPC_6502,MPC_8080,MPC_8086);
      local                           : char;

  procedure SkipString(var z:Zeile; var h1:Zeile);
  begin
    h1 := '';
    delete(z,1,1);
    repeat
      if pos(#39#39,z)=1 then
        delete(z,1,1);
      if z<>'' then begin
        h1 := h1+z[1];
        delete(z,1,1)
      end
    until (z='') or ((pos(#39,z)=1) and (pos(#39#39,z)<>1));
    if pos(#39,z)=1 then
      delete(z,1,1);
    SkipLeftBlanks(z);
    if pos(',',z)=1 then
      delete(z,1,1);
    SkipLeftBlanks(z)
  end;

  procedure SkipWord(var z:Zeile; var e:integer);
  var fc:integer;
      p : byte;
      h : boolean;
      t : Zeile;
  begin
    p := pos(',',z);
    if p=0 then begin
      t := z; z := ''
    end else begin
      t := copy(z,1,p-1);
      delete(z,1,p)
    end;
    SkipLeftBlanks(t); SkipRightBlanks(t);
    Berechne(t,e,fc);
    SkipLeftBlanks(z);
    if PASS=2 then
      h := Error(fc,t)
  end;

  procedure DBString(z:Zeile; var h1:Zeile);
  var e : integer;
      t : Zeile;
  begin
    h1 := '';
    SkipLeftBlanks(z);
    while z<>'' do
      if z[1]='''' then begin
        SkipString(z,t);
        h1 := h1+t;
        PC := PC+length(t)
      end else begin
        SkipWord(z,e);
        h1 := h1+chr(e);
        PC := succ(PC)
      end
  end;

  procedure DWString(z:Zeile; var h1:Zeile); 
  var e : integer;
      t : Zeile;
      h : boolean;
  begin
    h1 := '';
    SkipLeftBlanks(z);
    while z<>'' do
      if z[1]='''' then begin
        SkipString(z,t);
        if length(t)<>2 then begin
          h := Error(2,t);
          exit
        end else begin
          h1 := h1+t[2]+t[1];
          PC := PC+2;
        end
      end else begin
        SkipWord(z,e);
        h1 := h1+ chr(lo(e))+ chr(hi(e));
        PC := PC+2;
      end
  end;

  function PseudoOp(o:LabelString):PseudoOpcode;
  begin
    if o='ORG'                         then PseudoOp := pORG
    else if o='ASEG'                   then PseudoOp := pABS
    else if (o='DS') or (o='DEFS')     then PseudoOp := pDS
    else if (o='DB') or (o='DEFB')     then PseudoOp := pDB
    else if (o='DW') or (o='DEFW')     then PseudoOp := pDW
    else if (o='DL') or (o='DEFL')     then PseudoOp := pDL
    else if o='EXT'                    then PseudoOp := pEXT
    else if o='EQU'                    then PseudoOp := pEQU
    else if o='SET'                    then PseudoOp := pSET
    else if o='IF'                     then PseudoOp := pIF
    else if o='ELSE'                   then PseudoOp := pELSE
    else if o='ENDIF'                  then PseudoOp := pENDIF
    else if o='END'                    then PseudoOp := pEND
    else if o='MACRO'                  then PseudoOp := pMACRO
    else if o='.Z80'                   then PseudoOp := pZ80
    else if o='.6502'                  then PseudoOp := p6502
    else if o='.8080'                  then PseudoOp := p8080
    else if o='.8086'                  then PseudoOp := p8086
    else PseudoOp := pNO
  end;

begin   (* DoPass *)
  Prozessor := MPC_Z80;
  first := true;  local := 'A'; Aseg:=false;
  PC := 0; IfCount1 := 0; IfCount2 := 0;
  DoFlag[0] := true; TextStack := nil;
  reset(Source); EndOfSource := false;
  writeln('PASS ',PASS);
  if PASS=2 then
    if MakeINL then
      writeln(Objekt,'InLine (');
  while not (EOF(source)) and (not EndOfSource) do begin
    L := ''; L1 := '';
    PrintFlag := true;
    pc1 := PC; h1 := ''; Anzahl := 0;
    if TextStack = nil then
      begin
      SourceZeile:='';
      readln(Source,SourceZeile);
      end
    else
      PopZeile(SourceZeile);
    ScanLine(SourceZeile,Lab,OPCODE,Arg1,Arg2,Com,Local);
    POp := PseudoOp(OpCode);
    Do1 := DoFlag[IfCount1];
    if POp = pSET then
      if Arg2<>'' then
        POp := pNO;
    if (Lab<>'') and (Do1) and (not (POp in NoLabelOp)) then
      with te do begin
        VarName := Lab;
        Art := relativ;
        VarRef := PC;
        Suche(VarListe,te,SuchListe);
        if PASS=1 then
          if SuchListe=nil then
            FuegeEin(VarListe,te)
          else
            h := Error(7,Lab)
        else if SuchListe^.Eintrag.VarRef <> VarRef then
          h := Error(11,Lab)
     end;

   case POp of
     pIF     : begin
                 IfCount2 := succ(IfCount2);
                 PrintFlag := false;
                 if Do1 then begin
                   Berechne(Arg1,er,Fehler);
                   IfCount1 := succ(IfCount1);
                   DoFlag[IfCount1] := er<>0;
                   h := Error(Fehler,Arg1)
                 end
               end;
     pENDIF  : if IfCount2=0 then
                 h := Error(17,'')
               else begin
                 IfCount2 := pred(IfCount2);
                 PrintFlag := false;
                 if IfCount2=IfCount1-1 then
                   IfCount1 := pred(IfCount1)
               end;
     pELSE   : if IfCount2 = 0 then
                 h := Error(16,'')
               else begin
                 PrintFlag := false;
                 if IfCount1=IfCount2 then
                   if IfCount1>0 then
                     DoFlag[IfCount1] := not DoFlag[IfCount1]
               end
   end;  (* case *)

   if Do1 and (not(POp in [pIF,pENDIF,pELSE])) then
     with te do
       case POp of
         pMACRO : if PASS=1 then begin
                    if Arg2<>'' then
                      Arg1 := Arg1+','+Arg2;
                    MachMacro(Lab,Arg1)
                  end else begin
                    PrintFlag := false;
                    SkipMacro(Lab)
                  end;
         pEXT   : if Lab<>'' then begin
                    Art := Extern;
                    VarName := Lab;
                    FuegeEin(VarListe,te)
                  end;
         pEQU   : if Lab<>'' then begin
                    Art := absolut;
                    VarName := Lab;
                    Berechne(Arg1,VarRef,Fehler);
                    L1 := '('+HexWord(VarRef)+')';
                    if not Error(Fehler,Arg1) then begin
                      Suche(VarListe,te,SuchListe);
                      if PASS=1 then
                        if SuchListe=nil then
                          FuegeEin(VarListe,te)
                        else
                          h := Error(10,Lab)
                      else if SuchListe<>nil then
                        if SuchListe^.Eintrag.VarRef<>VarRef then
                          h := Error(11,Lab)
                    end
                  end;
         pSET   : if Lab<>'' then begin
                    Berechne(Arg1,VarRef,Fehler);
                    Art := absolut;
                    VarName := Lab;
                    L1 := '('+HexWord(VarRef)+')';
                    if not Error(Fehler,Arg1) then
                      FuegeEin(VarListe,te)
                  end;
         pDL    : if Lab<>'' then begin
                    Berechne(arg1,VarRef,Fehler);
                    if Fehler<0 then
                      Art := relativ
                    else
                      Art := absolut;
                    VarName := Lab;
                    L1 := '('+HexWord(VarRef)+')';
                    if not Error(Fehler,Arg1) then
                      FuegeEin(VarListe,te)
                  end;
         pDS    : begin
                    Berechne(Arg1,er,Fehler);
                    if not Error(Fehler,Arg1) then begin
                      PC := PC+er;
                      Anzahl := er
                    end
                  end;
         pDB    : begin
                    DBString(Arg1+','+Arg2,h1);
                  end;
         pDW    : begin
                    DWString(Arg1+','+Arg2,h1);
                  end;
         pABS   : Aseg:=true;
         pORG   : begin
                    Berechne(Arg1,er,Fehler);
                    if Aseg then
                       PC:=er;
                    if PASS=2 then 
                       writeln(Objekt,'(* *=',er,' *)')
                  end;
         pZ80   : Prozessor := MPC_Z80;
         p8080  : Prozessor := MPC_8080;
         p6502  : Prozessor := MPC_6502;
         p8086  : Prozessor := MPC_8086;
         pEND   : begin
                    EndOfSource := true;
                  end
         else if OPCODE <> '' then begin
           VarName := OPCODE;
           Suche(VarListe,te,SuchListe);
           if SuchListe <> nil then begin
             if SuchListe^.Eintrag.Art=macro then begin
               if Arg2<>'' then begin
                 Arg1 := Arg1+','+Arg2;
                 Arg2 := ''
               end;
               with SuchListe^,Eintrag do begin
                 PushMacro(MPtr^,Arg1);
                 local := MPtr^.local;
                 MPtr^.local := succ(local)
               end
             end
           end else begin
               case Prozessor of
                 MPC_Z80  : HexLine1(OPCODE,Arg1,Arg2,L);
                 (* .... *)
               end;
               PC := PC+ByteZahl(L);
               if L='' then begin
                 if Arg2<>'' then begin
                   Arg1 := Arg1+','+Arg2;
                   Arg2 := ''
                 end;
                 h := Error(14,OPCODE+' '+Arg1)
               end else if PASS=2 then
                 Konvertiere(PC-ByteZahl(L),L,Aseg)
           end
         end
       end  (* case *);

    if (PASS=2) and (PrintFlag) and (Do1) then begin
      if MakePRN then
        write(PRNFile,'*',HexWord(pc1),' ');
      if MakeINL then
        write(Objekt,L);
      if length(OpCode)>4 then  (* kein Z80-Befehl, also MACRO *)
        Arg1 := copy(Lab+'         ',1,9)+OPCODE+' '+Arg1
      else
        Arg1 := copy(Lab+'         ',1,9)+copy(OPCODE+'     ',1,5)+Arg1;
      if Arg2<>'' then
        Arg1 := Arg1+','+Arg2;
      if copy(Arg1,1,10)='          ' then
        Arg1:='';
      if Com<>'' then Arg1 := Arg1+' ;'+Com;
      if Anzahl>0 then begin
        str(Anzahl,L1);
        L1 := '('+L1+' Bytes res]';
        for i:= 1 to Anzahl do begin
          if not First then
            if MakeINL then
              write(Objekt,'/')
            else
          else
            First := false;
          if MakeINL then
            write(Objekt,'$00');
          if (i mod 19) = 0 then
            if MakeINL then writeln(Objekt);
        end;
        if (Anzahl mod 19)<>0 then
          if MakeINL then
            writeln(Objekt)
      end;
      if h1<>'' then
        for i:=1 to length(h1) do begin
          if first then
            first := false
          else begin
            if MakeINL then
              write(Objekt,'/');
            if MakePRN then
              write(PRNFile,'/')
          end;
          if MakeINL then
            write(Objekt,'$'+HexByte(ord(h1[i])));
          if MakePRN then
            write(PRNFile,'$'+HexByte(ord(h1[i])));
          if (i mod 19)=0 then
            if MakeINL then writeln(Objekt);
          if (i mod 6)=0 then
            if MakePRN then
              write(PRNFile,#13#10'*',HexWord(pc1+i),' ')
        end;
      if h1<>'' then
        if (length(h1) mod 19)<>0 then
          if MakeINL then
            writeln(Objekt);
      if Arg1<>'' then
        if KommentarFlag then
          if MakeINL then
            writeln(Objekt,'':24-length(L),'{ ',copy(arg1,1,45),
                                           ' }':47-length(Arg1))
          else
        else if L<>'' then
          if MakeINL then
            writeln(Objekt);
      if L='' then L:=L1;
      if h1='' then
        if MakePRN then
          write(PRNFile,L,'':24-length(l))
        else
      else
        for i := (length(h1) mod 6) to 5 do
          if MakePRN then
            write(PRNFile,'   ');
      if MakePRN then
        writeln(PRNFile,' ',copy(Arg1,1,51));
    end;
    PrintFlag := true
  end;

  if IfCount2>0 then
    h := Error(18,'');
    if PASS=2 then begin
      if MakeINL then
        writeln(Objekt,')');
      if FehlerZahl>0 then
        if MakeINL then
          writeln(Objekt,'(* ',FehlerZahl,' Fehler aufgetreten... *)')
    end;
    if MakePRN then
      writeln(PRNFile,FehlerZahl,' Fehler aufgetreten.')
end;

