;=============== Support Routines (extracted to save space ) =================
; Version for CDZSWP 1.2 - 28 April 2005.  HFB
;=============================================================================
; Print Opening Banner on Clear Screen

Banner:	CALL	CLS		; Start w/clear screen at Home pos'n
	CALL	VPRINT
	DEFB	1,' Z-System CD Sweep ',2
	DEFB	' V',VER/10+'0','.',VER MOD 10 + '0',' ('
	DATE
	DEFB	') by H.F.Bower (from CDSWEEP, D.Elvin)',CR,LF,0
	RET

;.....
; Check for loaded Driver by examining the Length field (word at offset 0).
; If this word is 0, search for the specified overlay file (as configured) in
; the Drive/User specified.  If found, load the first sector, checking the
; length field for an acceptable size (<= available space), and for the ID
; string at the specified location.  If all checks are Ok, load the file into
; position.

LdOvly:	LD	A,(FCB+1)
	CP	' '		; Absolute overlay argument entered?
	JR	NZ,LdOv00	; ..try to log and load if Yes

	LD	HL,(oStart)	; Get Length word
	LD	A,H
	OR	L		; Anything installed?
	RET	NZ		; ..return Ok if not, assume one is loaded

	LD	DE,FCB		; Pt to Default File Control Block
	LD	A,(drvDU+1)	;  fetch configured default drive
	INC	A		;   (+1 for base 1=A)
	LD	(DE),A
	INC	DE
	LD	HL,drvNam
	LD	BC,11
	LDIR			;   move default name.typ into FCB
	XOR	A
	LD	(DE),A		;     (init)
	INC	DE		;    bump to FCB+13
	LD	A,(drvDU)
	LD	(DE),A		;     move default user into pos'n
	XOR	A
	LD	B,21
LdOvlP:	INC	DE
	LD	(DE),A		;      Init (clear) rest of FCB
	DJNZ	LdOvlP

LdOv00:	LD	HL,FCB+9
	LD	A,(HL)
	CP	' '		; Any Type present?
	JR	NZ,LdOv01	; ..jump if Yes
	LD	(HL),'D'	; Else
	INC	HL		;  assume
	LD	(HL),'R'	;   .DRV
	INC	HL
	LD	(HL),'V'
LdOv01:	LD	DE,FCB
	CALL	Z3Log		; Log into configured FCB DU
	LD	HL,oStart	;  Pt to start of Overlay Area
	CALL	SetDMA		;   set for first transfer
	CALL	F$Open		; Can we Open the File?
	JR	NZ,LdOvE0	; ..jump to Error Exit if Not
	PUSH	HL
	CALL	F$Read		; Attempt to Read 1st Sector
	POP	DE
	JR	NZ,LdOvE1	; ..Take Error Exit if Error
	LD	HL,(oStart)	; Get length of Overlay File
	LD	BC,2048+1	;  Max length (+1)
	OR	A
	SBC	HL,BC		; Enough space for file?
	JR	NC,LdOvE2	; ..exit Error if Not
	PUSH	DE
	LD	HL,idStr	; Set up to validate ID String
	LD	DE,vStrng
	LD	B,VSLEN
LdOvLC:	LD	A,(DE)
	CP	(HL)		; Match?
	JR	NZ,LdOv0	; ..exit if Not
	INC	HL
	INC	DE
	DJNZ	LdOvLC		;  ..loop til all chars done Ok
LdOv0:	POP	HL
	JR	NZ,LdOvE3	; Jump to Error Exit if No Match
	LD	DE,FCB
LdOv1:	LD	BC,0080H
	ADD	HL,BC
	CALL	SetDMA		; Advance to next transfer Address
	CALL	F$Read		;  Read Sector
	JR	Z,LdOv1		; ..loop if Not Error/EOF
	CALL	F$Close		;    Assume we are at EOF and Close the File
	LD	HL,TBUFF	; Reset Default DMA Address to Default
	CALL	SetDMA
	XOR	A		; Indicate success
	RET

LdOvE0:	LD	HL,OvErM0
	DEFB	0DDH		; Trash IX, fall thru
LdOvE1:	LD	HL,OvErM1
	DEFB	0DDH
LdOvE2:	LD	HL,OvErM2
	DEFB	0FFH
LdOvE3:	LD	HL,OvErM3
	SCF			; Set Error Flag
	RET

OvErM0:	DEFB	BELL,'++ Can''t Open Overlay File!',0
OvErM1:	DEFB	BELL,'++ Error Reading Overlay File!',0
OvErM2:	DEFB	BELL,'++ Overlay File exceeds space!',0
OvErM3:	DEFB	BELL,'++ Error validating Overlay File!',0

vStrng:	DEFB	'CDROM-OVL'
VSLEN	  EQU  $-vStrng

;.....
; Position Cursor one line up from Bottom for Prompt Line

P_LinX:	LD	A,(nrows)
	DEC	A		; Use one line above prompt for status
	JR	P_LinV		; ..continue below to set @ Col 1

;.....
; Position Cursor at current display line

P_LinC:	LD	A,(current)	; Get Current relative Screen entry
	ADD	A,ROWOFF	;  offset to Row # (Rel File 0 at Row 4)
P_LinV:	LD	H,A
	LD	L,1		;   Row/Col
	JP	GotoXY		;    Place Cursor

;.....
; Position Cursor at Line 3, Col 1 and Clear rest of Screen

P_3Clr:	LD	HL,0301H	; Position near top of screen
	CALL	GotoXY
	JP	CLREOS		;  Clear Screen

;.....
; Clear Prompt Line

ClPrmp:	CALL	P_LinX		; Go to line we messed up
	JP	EREOL		;  Clear it & Return

;.....
; Load 32-bit LBA into prescribed registers for Overlay Read operation (BCDE)
; Enter: HL -> LBA in Little-Endian form
; Exit : BCDE = LBA (B=MSB..E=LSB)
;	 HL -> MSB of source location

GetLBA:	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	LD	C,(HL)
	INC	HL
	LD	B,(HL)
	RET

;----------- 32-bit Support routines ------------
; Increment 32-bit DWord addressed by HL

IncDW:	INC	(HL)		; Bump LSB
	RET	NZ		;  return if No O/V
	INC	HL
	INC	(HL)		;   carry thru
	RET	NZ
	INC	HL
	INC	(HL)
	RET	NZ
	INC	HL
	INC	(HL)
	RET

;....
; Decrement 32-bit DWord addressed by HL
; Exit: Zero Set (Z) if result is Zero

DecDW:	LD	A,(HL)
	SUB	1
	LD	(HL),A
	INC	HL
	LD	A,(HL)
	SBC	A,0
	LD	(HL),A
	INC	HL
	LD	A,(HL)
	SBC	A,0
	LD	(HL),A
	INC	HL
	LD	A,(HL)
	SBC	A,0
	LD	(HL),A
	DEC	HL
	OR	(HL)
	DEC	HL
	OR	(HL)
	DEC	HL
	OR	(HL)
	RET

;.....
; Transfer File Stamp data from CD-ROM form (addressed by HL) to ZsDOS form
; in both Create and Modify field in 15-byte buffer addressed by DE.  Set
; Last Accessed field to Current Time/Day
; Enter: HL -> CD-ROM File Stamp field
;	 DE -> 15-byte ZsDos File Stamp buffer
; Exit : None.  Data is converted and moved

; Uses : AF,BC,DE,HL

GSData:	PUSH	DE		; Save Dest Start Addr
	CALL	GSD00		; Get byte, convert and store (yr)
	CALL	GSD00		;  another (mn)
	CALL	GSD00		;   more (da)
	CALL	GSD00		;    one more (hr)
	CALL	GSD00		;     finally (min)
	PUSH	DE		; Save Addr of Last Access field
	LD	C,98		;  ZsDos Get Time Func
	CALL	BDOS		;   fetch
	POP	DE
	LD	HL,5
	ADD	HL,DE
	EX	DE,HL		; Addr of Modify Addr to DE
	POP	HL		;  Restore Addr of Create to HL
	LD	BC,5
	LDIR			;   copy converted Create to Modify
	RET			;    done!
	
GSD00:	LD	A,(HL)		; Get source byte
	INC	HL		;   (bump)
	LD	C,0FFH		; Set initial 10's value
	LD	B,10		;  and divisor
GSD01	INC	C
	SUB	B		; Divide by sequential subtraction
	JR	NC,GSD01	; ..loop til done
	ADD	A,B		;  correct for underflow
	LD	B,A		;   save digits
	LD	A,C		; Get 10s count
	RLCA			;  Move
	RLCA			;   to Hi
	RLCA			;    Nibble
	RLCA
	OR	B		;     add digits
	LD	(DE),A		; Store converted byte
	INC	DE		;   (bump)
	RET			;  back to caller

;.....
; Print byte in A as two Decimal Digits (No SYSLIB routine)
; Enter: A = byte to display
; Exit : None.  number displayed
; Uses : AF

PA2DC:	PUSH	BC
	LD	C,2FH		; Use C for tens (start at '0'-1)
PA2DC0:	INC	C		; Bump Tens count
	SUB	10		;  subtract 10
	JR	NC,PA2DC0	; ..loop til we go too far
	ADD	A,'0'+10	; Correct for underflow & make Ascii digit
	PUSH	AF		; Save remainder (ones)
	LD	A,C		;  Get 10s (ascii digit representation)
	CALL	COUT		;   print
	POP	AF		; Restore ascii units digit
	CALL	COUT		;   print
	POP	BC		;     restore Regs
	RET

;.....
; Display Help Message

HELP:	CALL	VPRINT
	DEFB	CR,LF,0
	CALL	STNDOUT		; Highlight the name
	CALL	COMNAM
	CALL	STNDEND		;  go normal attribs
	CALL	VPRINT
	DEFB	' allows you to examine the contents of a CD-ROM under'
	DEFB	' CP/M or',CR,LF
	DEFB	' Compatible Operating System with Z-System (ZCPR 3.x'
	DEFB	' or higher)',CR,LF
	DEFB	' enhancements.  It operates in Screen-oriented mode'
	DEFB	' using TCAP',CR,LF
	DEFB	' definitions for cursor movement.',CR,LF,LF
	DEFB	' A distinct driver section allows for embedded code to'
	DEFB	' define',CR,LF
	DEFB	' the CD-ROM interface, or to load a driver file at'
	DEFB	' run-time.',CR,LF,LF
	DEFB	' This program supports File Copy from a CD-ROM with'
	DEFB	' date-stamping',CR,LF
	DEFB	' and Control-Z padding to CP/M End-of-Record boundary,'
	DEFB	' File viewing',CR,LF
	DEFB	' with pagination and line-truncation, and easy'
	DEFB	' navigation',CR,LF
	DEFB	' using WordStar "like" keystrokes.',CR,LF,LF
	DEFB	'Syntax:',CR,LF,LF,TAB,0
	CALL	COMNAM
	CALL	VPRINT
	DEFB	'          - Execute the Program',CR,LF,TAB,0
	CALL	COMNAM
	CALL	VPRINT
	DEFB	' //       - Display this message',CR,LF,TAB,0
	CALL	COMNAM
	CALL	VPRINT
	DEFB	' [du:|dir:]driver.typ   - Execute with specific driver',0
	JP	Finis		; ..and exit back to CCP

;.....
; Parse Default Name/Type String in HL into FCB.  If user enters
;  simple RETurn, exit to use default; else parse user input.
; Enter: HL -> Null-terminated FN[.FT] string
; Exit :  A = Number of "?" in string, Zero Flag set accordingly
;		Carry Set if A # 0 or other error, Else Clear (NC)
;	    Parsed name (default or entered) in default FCB

GetFN:	LD	DE,FCB		; Pt to Dest FCB
	XOR	A		;  Scan for DIR before DU
	CALL	ZPRSFN
	PUSH	AF
	CALL	GetLin		; Get any User specs
	JR	NZ,GetFN0	; ..jump continue if input
	POP	AF		; Else Restore flags from default parse
	JR	GetFN2		; ..exit clearing Carry

GetFN0:	POP	AF		; Clear stack
	LD	HL,LINBUF
	LD	DE,TBUFF	; Parse into Dflt Buffer in case just DU/DIR:
	XOR	A		;  Scan for DIR before DU
	CALL	ZPRSFN		;   parse line into FCB, return via stack
	SCF			;     (Set Carry in case)
	RET	NZ		;  ..return Error if ambiguous name
	LD	HL,TBUFF+1
	LD	A,(HL)		;     Get first char
	CP	' '		; Any name entered?
	JR	Z,GetFN1	; ..jump if Not to just copy DU bytes
	LD	DE,FCB+1
	LD	BC,11
	LDIR			;  Move FN.FT to FCB
GetFN1:	LD	A,(TBUFF)
	LD	(FCB),A		;   Move Drive
	LD	A,(TBUFF+13)
	LD	(FCB+13),A	;    and User
GetFN2:	SCF			; Set Carry
	CCF			;  Complement to Clear
	RET			;    return Ok status

;.....
; Get a line of input from the operator, echoing input
; Return: A=0, Zero Flag Set (Z) if a Null line entered
;	 HL -> First char of Null-terminated string if Present

GetLin:	LD	HL,linBuf	; Pt to Console buffer
GetLn0:	LD	(HL),0		;  insuring initialization
	OR	0FFH		; Echo input
	CALL	INLINE		;  get user string
	LD	A,(HL)
	OR	A		;   Set Zero Flag if Nothing entered
	RET

;.....
; Display short prompt, accept any key press and return
;  Used to pause after error messages.
; Enter: None
; Exit : None (char in A
; Uses : AF

AnyKey:	CALL	VPRINT
	DEFB	'  [press any key]',0
	JP	CIN		; Get Char in A, return via stack

;.....
; Print name by which invoked or default name

COMNAM:	LD	A,(ENVADR+1)	; Get High byte of ENV Pointer
	OR	A		; Anything there?
	JP	NZ,PRTNAME	; ..jump to print "real" name if so
	CALL	VPRINT		; Else print default name
	DEFB	'CDINIT',0
	RET

;= = = = = = = = = End of CDZSWP0.INC = = = = = = = = = =
