/***************************************************
 UZI (Unix Z80 Implementation) Utilities:  ssh.c
  Simple Shell.  Copyright (C) 1998, Harold F. Bower

 15 Mar 1998 - Added Path searching from Minix.  HFB
****************************************************/
#include <stdio.h>

extern char ** environ;      /* Location of Envp from executable Header */
extern char  * getenv (char *);

char buf[128];
char eline[45];				/* Line for Search command */
char *envp1[] = { "HOME=/usr", "PATH=.:/bin:/:/usr/bin", "CTTY=/dev/tty0", 0};
char cmd[30], arg1[30], arg2[30], arg3[30], arg4[30], arg5[30];


/*
 *  Return 1 if character c is in string s, Else return 0.
 */
int
any (c, s)
int  c;
register char  *s;
{
    while (*s)
        if (*s++ == c)
            return (1);
    return (0);
}


main (argc, argval)
int argc;
char **argval;
{
    char  * path, * tp, * sp;         /* Pointers for Path Searching */
    char  * argv[7];
    int     pid, tty1, stat, count, asis, i;
    char  * tenvp;
    int     strlen(), strcmp(), fork(), execve(), fopen(), chdir();
    int     sscanf();

    tenvp = *environ;
    path = getenv ("PATH");     /* Get base of Path String, or Null */

    while (1)
    {
        cmd[0] = arg1[0] = arg2[0] = arg3[0] = arg4[0] = arg5[0] = (char) 0;
        do
        {
            printf ("\n[SSH]: ");
            fgets (buf, 127, stdin);
            buf[(strlen (buf) - 1)] = '\0';   /* Strip newline from fgets */
        }
        while (buf[0] == (char) 0);
        printf ("\n");
        count = sscanf (buf, "%s %s %s %s %s", cmd, arg1, arg2, arg3, arg4);

          /* Check for User-Requested Exit back to Login Prompt */
        if (strcmp (cmd, "exit") == 0)
            return (0);                      /* Quit if requested */

          /* Check for User request to change Current Working Directory */
        else if (strcmp (cmd, "cd") == 0)
        {
            if (count == 2)
            {
                stat = chdir (arg1);
                if (stat)
                    printf ("  cd: Error %d\n", stat);
                else
                    printf ("  logging into : %s\n", arg1);
            }
            else
                printf ("  cd ?\n");
        }

          /* No built-in Command, Try to find Executable Command File */
        else
        {
            argv[0] = cmd;                  /* Build Argv Pointer Array */
            argv[1] = *arg1 ? arg1 : NULL;
            argv[2] = *arg2 ? arg2 : NULL;
            argv[3] = *arg3 ? arg3 : NULL;
            argv[4] = *arg4 ? arg4 : NULL;

            if ((pid = fork()) == -1)       /* Try to spawn new Process */
                printf ("SSH: can't fork");
            else
            {
                if (pid == 0)
                {                                   /* Child is in context */
                    /* Path search adapted from Univ of Washington's Minix */
                    eline[0] = '\0';
                    sp = any ('/', cmd) ? "" : path;
                    asis = *sp == '\0';
                    while (asis || *sp != '\0') {
                        asis = 0;
                        tp = eline;
                        for (; *sp != '\0'; tp++)
                            if ((*tp = *sp++) == ':') {
                                asis = *sp == '\0';
                                break;
                            }
                        if (tp != eline)
                            *tp++ = '/';
                        for (i = 0; (*tp++ = cmd[i++]) != '\0';)
                            ;
                        execve (eline, argv, envp1);
                    }
                    printf ("  %s?\n", buf);         /* Say we can't exec */
                    exit (1);
                }                                   /* Parent is in context */
                wait (0);                    /* Parent waits for completion */
                kill (pid, 9);                /*  then kills child process */
            }
        }
    }
}
